<?php
/**
 * Template Name: Blog 2 Column
 *
 * @package ranbron
 */

get_header(); ?>

<?php do_action( 'tt_before_mainblock' ); ?>
<div class="blog-with-sidebar two-col sec-pad">
	<div class="thm-container">
		<div class="row blog-sidebar-wrapper">

			<?php
			$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
			$args  = array(
				'post_type' => 'post',
				'paged'     => $paged
			);

			global $wp_query;
			$original_query = $wp_query;

			// query
			$tt_query = new WP_Query( $args );
			$wp_query = $tt_query;

			// loop
			if ($tt_query->have_posts()) :
			while ( $tt_query->have_posts() ) : $tt_query->the_post();
				?>

			<div <?php post_class('col-md-6'); ?>>
				<div class="single-blog-post-sidebar clearfix">
			    <?php if ( has_post_thumbnail() ) : ?>
			        <div class="img-box">
			        <a class="ht-imagehover" href="<?php the_permalink(); ?>"><?php the_post_thumbnail('ranbron-blog2col'); ?></a>
				    </div>
			    <?php endif; ?>
					<?php get_template_part( 'templates/entry-meta' ); ?>
			        <?php the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
					<?php
					the_excerpt();
					?>
					<a href="<?php the_permalink(); ?>" class="read-more"><?php esc_html_e('Read more', 'ranbron'); ?></a>
				</div><!-- /.single-blog-post-sidebar -->
			</div><!-- /.col-md-6 -->
			<?php
			endwhile; ?>

		</div><!-- /.row -->
		<div class="blog-post-pagination">
			<?php
			// Previous/next page navigation.
			the_posts_pagination( array(
				'prev_text'          => esc_html__( '<', 'ranbron' ),
				'next_text'          => esc_html__( '>', 'ranbron' ),
				'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'ranbron' ) . ' </span>',
			) );
			?>
		</div><!-- /.blog-post-pagination -->
		<?php endif; ?>
		<?php wp_reset_postdata(); ?>

		<?php $wp_query = $original_query; ?>
	</div><!-- /.thm-container -->
</div>

<?php get_footer(); ?>
