<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package ranbron
 */

get_header(); ?>

<?php ranbron_hero_bg(); ?>

    <div class="blog-with-sidebar sec-pad mainblock" id="wrapper-index">
        <div class="thm-container">
            <div class="row">


           <div id="primary" class="<?php if ( is_active_sidebar( 'default-sidebar' ) ) : ?>col-md-9<?php else : ?>col-md-12<?php endif; ?> content-area">

                <main id="main" class="site-main has-right-sidebar">

                <?php if( is_archive()) {
					the_archive_title( '<h1 class="ml-title page-title">', '</h1>' );
					the_archive_description( '<div class="taxonomy-description">', '</div>' );
				?>
		        <div class="mbottom55"></div>
		        <?php } ?>

                <?php if( is_search()) { ?>
                <header class="page-header">
                    <h1 class="page-title ml-title">
                        <?php printf( esc_html__( 'Search Results for: %s', 'ranbron' ), '<span>' . get_search_query() . '</span>' ); ?>
                    </h1>
                </header><!-- .page-header -->
				<div class="mbottom55"></div>
		        <?php } ?>

                <?php if ( have_posts() ) : ?>
					<div class="blog_listing_inner blog_pad_right">
                        <?php /* Start the Loop */ ?>

                        <?php while ( have_posts() ) : the_post(); ?>

                                <?php
                                    /* Include the Post-Format-specific template for the content.
                                     * If you want to override this in a child theme, then include a file
                                     * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                                     */
                                    get_template_part( 'templates/content', get_post_format() );
                                ?>

                        <?php endwhile; ?>

						<div class="blog-post-pagination blog-pag">
							<?php
							// Previous/next page navigation.
							the_posts_pagination( array(
								'prev_text'          => esc_html__( '<', 'ranbron' ),
								'next_text'          => esc_html__( '>', 'ranbron' ),
								'before_page_number' => '<span class="meta-nav screen-reader-text">' . esc_html__( 'Page', 'ranbron' ) . ' </span>',
							) );
							?>
						</div><!-- /.blog-post-pagination -->
						</div>
                <?php else : ?>

                    <?php get_template_part( 'templates/content', 'none' ); ?>

                <?php endif; ?>

                </main><!-- #main -->

           </div><!-- #primary -->

        <?php get_sidebar(); ?>

        </div><!-- .row -->

   </div><!-- Container end -->

</div><!-- Wrapper end -->

<?php get_footer(); ?>