<?php
/**
 * Declaring widgets
 *
 *
 * @package ranbron
 */
function ranbron_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar ( Default )', 'ranbron' ),
		'id'            => 'default-sidebar',
		'description'   => esc_html__( 'Sidebar widget area', 'ranbron' ),
		'before_widget' => '<aside id="%1$s" class="single-sidebar widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<div class="title"><h3 class="widget-title">',
		'after_title'   => '</h3></div>',
	) );



    // Footer widgetized areas
	$total = ranbron_fw_get_option( 'footer_sidebars', 4 );
	if ( ! $total ) $total = 4;
	if ( $total > '4' ) $total = 4; /* we dont want more than 4 footer widgets. */
	for ( $i = 1; $i <= intval( $total ); $i++ ) {
			register_sidebar( array(
				 'name'          => sprintf( esc_html__( 'Footer %d', 'ranbron' ), $i ),
                 'id'            => sprintf( 'footer-%d', $i ),
                 'description'   => sprintf( esc_html__( 'Widgetized Footer Region %d.', 'ranbron' ), $i ),
                 'before_widget' => '<div id="%1$s" class=" footer-widget widget %2$s">',
                 'after_widget'  => '</div>',
                 'before_title'  => '<div class="title"><h3>',
                 'after_title'   => '</h3></div>'
			) );
		}

}
add_action( 'widgets_init', 'ranbron_widgets_init' );

