<?php



require_once SEEDPROD_PLUGIN_PATH . 'resources/data-templates/basic-page.php';


global $wpdb;

// look for mixed content and mis configured WordPress sites.
$actual_link          = ( isset( $_SERVER['HTTPS'] ) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http' ) . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
$seedprod_builder_url = wp_parse_url( $actual_link );
$mixed_content        = false;
if ( false !== $seedprod_builder_url ) {
	if ( ! empty( $seedprod_builder_url['scheme'] && $seedprod_builder_url['scheme'] == 'https' ) ) {
		$sp_home_url        = get_option( 'home' );
		$sp_home_url_parsed = wp_parse_url( $sp_home_url );
		$sp_site_url        = get_option( 'siteurl' );
		$sp_site_url_parsed = wp_parse_url( $sp_site_url );

		if ( ! empty( $sp_home_url_parsed['scheme'] ) && $sp_home_url_parsed['scheme'] == 'http' ) {
			$mixed_content = true;
		}

		if ( ! empty( $site_url_parsed['scheme'] ) && $site_url_parsed['scheme'] == 'http' ) {
			$mixed_content = true;
		}
	}
}


// current user
$sp_current_user           = wp_get_current_user();
$current_user_name         = $sp_current_user->display_name;
$current_user_email        = $sp_current_user->user_email;
$current_user_email_hash   = md5( $sp_current_user->user_email );
$free_templates_subscribed = get_option( 'seedprod_free_templates_subscribed' );
if ( $free_templates_subscribed ) {
	$free_templates_subscribed = '1';
}
$seedprod_nonce = wp_create_nonce( 'seedprod_nonce' );


$lpage_id = '';
if ( ! empty( $_GET['id'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
	$lpage_id = absint( $_GET['id'] ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
} else {
	wp_die();
}

// Template Vars
$timezones     = seedprod_lite_get_timezones();
$times         = seedprod_lite_get_times();
$block_options = seedprod_lite_block_options();


// get page
$tablename = $wpdb->prefix . 'posts';
$sql       = "SELECT * FROM $tablename WHERE id = %d";
$safe_sql  = $wpdb->prepare( $sql, $lpage_id ); // phpcs:ignore
$lpage     = $wpdb->get_row( $safe_sql ); // phpcs:ignore

// reset id
$lpage->id = $lpage->ID;

// Get page uuid
$lpage_uuid = get_post_meta( $lpage->id, '_seedprod_page_uuid', true );
if ( empty( $lpage_uuid ) ) {
	$this_uuid = wp_generate_uuid4();
	update_post_meta( $lpage->id, '_seedprod_page_uuid', $this_uuid );
	$lpage_uuid = $this_uuid;
}

// add default settings if they do not exisits
if ( empty( $lpage->post_content_filtered ) ) {
	require_once SEEDPROD_PLUGIN_PATH . 'resources/data-templates/basic-page.php';
	$settings                            = json_decode( $seedprod_basic_lpage, true );
	$settings['page_type']               = 'lp';
	$settings['from_edit_with_seedprod'] = true;
	// TODO Check if theme builder active
	if ( ! empty( $_GET['from'] ) && 'post' === $_GET['from'] ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$settings['page_type'] = 'post'; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
	}
} else {
	// get settings and maybe modify
	$settings = json_decode( $lpage->post_content_filtered, true );
}

// Check is this is a seedprod template part or page/post using the seedprod editor
$seedprod_is_theme_template = get_post_meta( $lpage_id, '_seedprod_is_theme_template', true );
$edited_with_seedprod       = get_post_meta( $lpage_id, '_seedprod_edited_with_seedprod', true );
if ( empty( $seedprod_is_theme_template ) ) {
	$seedprod_is_theme_template = get_post_meta( $lpage_id, '_seedprod_edited_with_seedprod', true );
}
if ( empty( $seedprod_is_theme_template ) ) {
	if ( 'post' === $settings['page_type'] ) {
		$seedprod_is_theme_template = 1;
	}
}

// Check for landing page types
$is_landing_page    = true;
$landing_page_types = array( 'cs', 'mm', 'p404', 'loginp', 'lp' );
if ( ! in_array( $settings['page_type'], $landing_page_types, true ) ) {
	$is_landing_page = false;
}


// get post types
$post_types = get_post_types();

// get seedprod setting tp check special pages states
$seedprod_settings = get_option( 'seedprod_settings' );
if ( ! empty( $seedprod_settings ) ) {
	$seedprod_settings = json_decode( stripslashes( $seedprod_settings ) );
}


// get global css settings
$global_css_settings = array();
$global_css_page_id  = get_option( 'seedprod_global_css_page_id' );




// get preview link
//$preview_link = get_preview_post_link( $lpage_id );
if ( 'lp' === $settings['page_type'] ) {
	$preview_link = home_url() . "/?page_id=$lpage_id&preview_id=$lpage_id&preview_nonce=" . wp_create_nonce( 'post_preview_' . $lpage_id ) . '&preview=true';
} else {
	$preview_link = home_url() . "/?post_type=seedprod&page_id=$lpage_id&preview_id=$lpage_id&preview_nonce=" . wp_create_nonce( 'post_preview_' . $lpage_id ) . '&preview=true';
}

// keep track for changes
$settings['post_title']  = $lpage->post_title;
$settings['post_name']   = $lpage->post_name;
$settings['post_status'] = $lpage->post_status;

$show_bottombar_cta    = true;
$dismiss_bottombar_cta = get_option( 'seedprod_dismiss_upsell_2' );
if ( $dismiss_bottombar_cta ) {
	$show_bottombar_cta = false;
}


// Email integration logic
$seedprod_api_token  = get_option( 'seedprod_api_token' );
$seedprod_user_id    = get_option( 'seedprod_user_id' );
$seedprod_site_token = get_option( 'seedprod_token' );
if ( empty( $seedprod_site_token ) ) {
	$seedprod_site_token = wp_generate_uuid4();
	update_option( 'seedprod_token', $seedprod_site_token );
}
$license_key           = get_option( 'seedprod_api_key' );
$email_integration_url = '';


$seedprod_app_settings = get_option( 'seedprod_app_settings' );
if ( ! empty( $seedprod_app_settings ) ) {
	$seedprod_app_settings = json_decode( stripslashes( $seedprod_app_settings ) );
} else {
	// fail safe incase settings go missing
	require_once SEEDPROD_PLUGIN_PATH . 'resources/data-templates/default-settings.php';
	update_option( 'seedprod_app_settings', $seedprod_app_default_settings );
	$seedprod_app_settings = json_decode( $seedprod_app_default_settings );
}


$template_preview_path = 'https://assets.seedprod.com/preview-';


// Pers
$per                        = array();
$active_license             = false;
$template_dev_mode          = false;
$template_dev_mode_url      = false;
$template_dev_mode_password = false;

?>


<style>
.sp-mobile-view  .sp-w-full {
	width: 100% !important;
}

.sp-mobile-view .sp-el-section,.sp-mobile-view .sp-el-row,.sp-mobile-view .sp-el-col,.sp-mobile-view .sp-el-block{
	padding: 5px !important;
}

.sp-mobile-view .sm\:sp-flex {
	display: block;
}

.mce-content-body {
	line-height: 1.5;
}

h1.mce-content-body,h2.mce-content-body,h3.mce-content-body,h4.mce-content-body,h5.mce-content-body,h6.mce-content-body {
	line-height: 1.1;
}
</style>

<div id="seedprod-vue-app-builder" class="sp-font-sans"></div>

<?php
	$fontawesome_file = SEEDPROD_PLUGIN_PATH . 'resources/data-templates/fontawesome.json';
	$fontawesome_json = json_decode( file_get_contents( $fontawesome_file ) ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_get_contents_file_get_contents
	$icons            = array();
foreach ( $fontawesome_json as $v ) {
	$icons[] = array(
		'c' => 'fa',
		'n' => $v,
	);
}

	$googlefonts_file = SEEDPROD_PLUGIN_PATH . 'resources/data-templates/googlefonts.json';

	$fonts['Standard Fonts'] = array(
		"'Helvetica Neue', Arial, sans-serif"   => 'Helvetica Neue',
		'Garamond, serif'                       => 'Garamond',
		'Georgia, serif'                        => 'Georgia',
		'Impact, Charcoal, sans-serif'          => 'Impact',
		'Tahoma, Geneva, sans-serif'            => 'Tahoma',
		"'Times New Roman', Times,serif"        => 'Times New Roman',
		"'Trebuchet MS', Helvetica, sans-serif" => 'Trebuchet',
		'Verdana, Geneva, sans-serif'           => 'Verdana',
		'Courier, monospace'                    => 'Courier',
		"'Comic Sans MS', cursive"              => 'Comic Sans',
	);
	$fonts['Google Fonts']   = json_decode( file_get_contents( $googlefonts_file ) ); // phpcs:ignore WordPress.WP.AlternativeFunctions.file_get_contents_file_get_contents
	//$googlefonts_json = json_decode(file_get_contents($googlefonts_file));

	//get list of fonts to load
	$google_fonts_str = seedprod_lite_construct_font_str( $settings['document'] );

	?>

<?php if ( ! empty( $google_fonts_str ) ) : ?>
<!-- Google Font -->
<link rel="stylesheet" href="<?php echo esc_url( $google_fonts_str ); ?>"> <?php // phpcs:ignore WordPress.WP.EnqueuedResources.NonEnqueuedStylesheet ?>
<?php endif; ?>

<script>
var seedprod_nonce = <?php echo wp_json_encode( $seedprod_nonce ); ?>;
var seedprod_page = <?php echo wp_json_encode( sanitize_text_field( wp_unslash( $_GET['page'] ) ) ); ?>; <?php // phpcs:ignore ?>
var seedprod_remote_api = "<?php echo esc_url( SEEDPROD_API_URL ); ?>";
<?php
$from = '';
if ( ! empty( $_GET['from'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
	$form = sanitize_text_field( wp_unslash( $_GET['from'] ) ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
}
?>
var seedprod_from = <?php echo wp_json_encode( $from ); ?>;
<?php
// see if we need below
$ajax_url = html_entity_decode( wp_nonce_url( 'admin-ajax.php?action=seedprod_lite_save_template', 'seedprod_lite_save_template' ) );
?>
var seedprod_template_save_url = <?php echo wp_json_encode( esc_url_raw( $ajax_url ) ); ?>;

<?php $ajax_url = html_entity_decode( wp_nonce_url( 'admin-ajax.php?action=seedprod_lite_template_subscribe', 'seedprod_lite_template_subscribe' ) ); ?>
var seedprod_template_subscribe_url = <?php echo wp_json_encode( esc_url_raw( $ajax_url ) ); ?>;

<?php $ajax_url = html_entity_decode( wp_nonce_url( 'admin-ajax.php?action=seedprod_lite_save_page', 'seedprod_lite_save_page' ) ); ?>
var seedprod_save_lpage_url = <?php echo wp_json_encode( esc_url_raw( $ajax_url ) ); ?>;

<?php $utc_url = html_entity_decode( wp_nonce_url( 'admin-ajax.php?action=seedprod_lite_get_utc_offset', 'seedprod_lite_get_utc_offset' ) ); ?>
var seedprod_utc_url = <?php echo wp_json_encode( esc_url_raw( $utc_url ) ); ?>;

<?php $get_namespaced_custom_css_url = html_entity_decode( wp_nonce_url( 'admin-ajax.php?action=seedprod_lite_get_namespaced_custom_css', 'seedprod_lite_get_namespaced_custom_css' ) ); ?>
var seedprod_get_namespaced_custom_css_url = <?php echo wp_json_encode( esc_url_raw( $get_namespaced_custom_css_url ) ); ?>;

<?php $stockimages_url = html_entity_decode( wp_nonce_url( 'admin-ajax.php?action=seedprod_lite_get_stockimages', 'seedprod_lite_get_stockimages' ) ); ?>
var seedprod_stockimages_url = <?php echo wp_json_encode( esc_url_raw( $stockimages_url ) ); ?>;

<?php $backgrounds_sideload_url = html_entity_decode( wp_nonce_url( 'admin-ajax.php?action=seedprod_lite_backgrounds_sideload', 'seedprod_lite_backgrounds_sideload' ) ); ?>
var seedprod_backgrounds_sideload_url = <?php echo wp_json_encode( esc_url_raw( $backgrounds_sideload_url ) ); ?>;

<?php $backgrounds_download_url = html_entity_decode( wp_nonce_url( 'admin-ajax.php?action=seedprod_lite_backgrounds_download', 'seedprod_lite_backgrounds_download' ) ); ?>
var seedprod_backgrounds_download_url = <?php echo wp_json_encode( esc_url_raw( $backgrounds_download_url ) ); ?>;

<?php $ajax_url = html_entity_decode( wp_nonce_url( 'admin-ajax.php?action=seedprod_lite_slug_exists', 'seedprod_lite_slug_exists' ) ); ?>
var seedprod_slug_exists_url = <?php echo wp_json_encode( esc_url_raw( $ajax_url ) ); ?>;

<?php $seedprod_upgrade_link = seedprod_lite_upgrade_link( '' ); ?>

<?php $url = seedprod_lite_get_plugins_install_url( 'all-in-one-seo-pack' ); ?>
var seedprod_seo_install_link = <?php echo wp_json_encode( esc_url_raw( htmlspecialchars_decode( $url ) ) ); ?>;

<?php $url = seedprod_lite_get_plugins_install_url( 'wpforms-lite' ); ?>
var seedprod_form_install_link = <?php echo wp_json_encode( esc_url_raw( htmlspecialchars_decode( $url ) ) ); ?>;

<?php $url = seedprod_lite_get_plugins_install_url( 'rafflepress' ); ?>
var seedprod_giveaway_install_link = <?php echo wp_json_encode( esc_url_raw( htmlspecialchars_decode( $url ) ) ); ?>;

<?php $url = seedprod_lite_get_plugins_install_url( 'google-analytics-for-wordpress' ); ?>
var seedprod_analytics_install_link = <?php echo wp_json_encode( esc_url_raw( htmlspecialchars_decode( $url ) ) ); ?>;

<?php
	$url = seedprod_lite_get_plugins_activate_url( 'google-analytics-for-wordpress/googleanalytics.php' );
?>

var seedprod_analytics_activate_link = <?php echo wp_json_encode( esc_url_raw( htmlspecialchars_decode( $url ) ) ); ?>;

<?php
	$url = seedprod_lite_get_plugins_activate_url( 'wpforms-lite/wpforms.php' );
?>

var seedprod_form_activate_link = <?php echo wp_json_encode( esc_url_raw( htmlspecialchars_decode( $url ) ) ); ?>;

<?php
	$url = seedprod_lite_get_plugins_activate_url( 'all-in-one-seo-pack/all_in_one_seo_pack.php' );
?>
var seedprod_seo_activate_link = <?php echo wp_json_encode( esc_url_raw( htmlspecialchars_decode( $url ) ) ); ?>;

<?php $ajax_url = html_entity_decode( wp_nonce_url( 'admin-ajax.php?action=seedprod_lite_install_addon', 'seedprod_lite_install_addon' ) ); ?>
var seedprod_get_install_addon_url = <?php echo wp_json_encode( esc_url_raw( $ajax_url ) ); ?>;

<?php $ajax_url = html_entity_decode( wp_nonce_url( 'admin-ajax.php?action=seedprod_lite_activate_addon', 'seedprod_lite_activate_addon' ) ); ?>
var seedprod_activate_addon_url = <?php echo wp_json_encode( esc_url_raw( $ajax_url ) ); ?>;

<?php $ajax_url = html_entity_decode( wp_nonce_url( 'admin-ajax.php?action=seedprod_lite_deactivate_addon', 'seedprod_lite_deactivate_addon' ) ); ?>
var seedprod_deactivate_addon_url = <?php echo wp_json_encode( esc_url_raw( $ajax_url ) ); ?>;

<?php $ajax_url = html_entity_decode( wp_nonce_url( 'admin-ajax.php?action=seedprod_lite_plugin_nonce', 'seedprod_lite_plugin_nonce' ) ); ?>
var seedprod_plugin_nonce_url = <?php echo wp_json_encode( esc_url_raw( $ajax_url ) ); ?>;

<?php $ajax_url = html_entity_decode( wp_nonce_url( 'admin-ajax.php?action=seedprod_lite_dismiss_upsell', 'seedprod_lite_dismiss_upsell' ) ); ?>
var seedprod_dismiss_upsell = <?php echo wp_json_encode( esc_url_raw( $ajax_url ) ); ?>;

<?php
	// user has to have this capability
	$unfiltered_html = false;
if ( current_user_can( 'unfiltered_html' ) ) {
	$unfiltered_html = true;
}
?>

<?php
	// get menus
	$seedprod_menus      = wp_get_nav_menus();
	$seedprod_options    = array();
	$seedprod_first_menu = '';
if ( count( $seedprod_menus ) > 0 ) {
	$menu_counter = 0;
	foreach ( $seedprod_menus as $sp_menu ) {
		if ( 0 === $menu_counter ) {
			$seedprod_first_menu = $sp_menu->slug;
		}
		$menu_counter++;
		$seedprod_options[ $sp_menu->slug ] = $sp_menu->name;
	}
}
?>

<?php
	// get tempplate parts
	$seedprod_template_parts = array();
	$seedprod_theme_parts    = array();
	$seedprod_selected_template_parts = '';
if ( count( $seedprod_theme_parts ) > 0 ) {

	$counter = 0;
	foreach ( $seedprod_theme_parts as $tparts ) {
		if ( 0 === $counter ) {
			$seedprod_selected_template_parts = $tparts->ID; }
			$counter++;
			$seedprod_template_parts[ $tparts->ID ] = $tparts->post_title;
	}
}

?>


var seedprod_data = 
<?php
$seedprod_data = array(
	'seedprod_settings'                => $seedprod_settings,
	'mixed_content'                    => $mixed_content,
	'is_landing_page'                  => $is_landing_page,
	'edited_with_seedprod'             => $edited_with_seedprod,
	'unfiltered_html'                  => $unfiltered_html,
	'global_css_page_id'               => $global_css_page_id,
	'global_css_settings'              => $global_css_settings,
	'show_bottombar_cta'               => $show_bottombar_cta,
	'template_preview_path'            => $template_preview_path,
	'page_uuid'                        => $lpage_uuid,
	'placeholder_image'                => SEEDPROD_PLUGIN_URL . 'public/img/img-placeholder.png',
	'placeholder_sm_image'             => SEEDPROD_PLUGIN_URL . 'public/img/img-placeholder-sm.png',
	'block_templates'                  => json_decode( $seedprod_lite_block_templates ),
	'seedprod_menus'                   => $seedprod_options,
	'seedprod_first_menu'              => $seedprod_first_menu,
	'expire_times'                     => seedprod_lite_get_expire_times(),
	'roles'                            => seedprod_lite_get_roles(),
	'my_ip'                            => seedprod_lite_get_ip(),
	'plugins_installed'                => seedprod_lite_get_plugins_array(),
	'giveaway_plugins_installed'       => seedprod_lite_get_giveaway_plugins_list(),
	'form_plugins_installed'           => seedprod_lite_get_form_plugins_list(),
	'seo_plugins_installed'            => seedprod_lite_get_seo_plugins_list(),
	'analytics_plugins_installed'      => seedprod_lite_get_analytics_plugins_list(),
	'seedprod_template_parts'          => $seedprod_template_parts,
	'seedprod_selected_template_parts' => $seedprod_selected_template_parts,
	'page_type'                        => $settings['page_type'],
	'current_user_name'                => $current_user_name,
	'current_user_email_hash'          => $current_user_email_hash,
	'current_user_email'               => $current_user_email,
	'free_templates_subscribed'        => $free_templates_subscribed,
	'preview_link'                     => $preview_link,
	'icons'                            => $icons,
	'googlefonts'                      => $fonts,
	'api_token'                        => $seedprod_api_token,
	'seedprod_user_id'                 => $seedprod_user_id,
	'site_token'                       => $seedprod_site_token,
	'license_key'                      => $license_key,
	'page_path'                        => 'seedprod_lite',
	'plugin_path'                      => SEEDPROD_PLUGIN_URL,
	'web_path'                         => SEEDPROD_WEB_API_URL,
	'home_url'                         => home_url(),
	'upgrade_link'                     => $seedprod_upgrade_link,
	'lpage'                            => $lpage,
	'settings'                         => $settings,
	'app_settings'                     => $seedprod_app_settings,
	'block_options'                    => $block_options,
	'timezones'                        => $timezones,
	'times'                            => $times,
	'template_dev_mode'                => $template_dev_mode,
	'template_dev_mode_url'            => $template_dev_mode_url,
	'template_dev_mode_password'       => $template_dev_mode_password,
	'email_integration_url'            => $email_integration_url,
	'per'                              => $per,
	'active_license'                   => $active_license,
	'is_theme_template'                => $seedprod_is_theme_template,
);


	$seedprod_data['wpforms'] = array(
		'edit_form_url' => admin_url( 'admin.php?page=wpforms-builder&view=fields&form_id=' ),
		'add_form_url'  => admin_url( 'admin.php?page=wpforms-builder&view=setup' ),
		'placeholder'   => sprintf( '<img src="%s" width="80px" alt="WPForms Logo"/>', esc_url( SEEDPROD_PLUGIN_URL . 'public/img/plugin-wpforms.png' ) ),
	);

	$rp_version = 'lite';
	if ( function_exists( 'rafflepress_pro_load_textdomain' ) ) {
		$rp_version = 'pro';
	}

	$seedprod_data['rafflepress'] = array(
		'edit_form_url' => admin_url( 'admin.php?page=rafflepress_' . $rp_version . '_builder&id=$id$#/setup/$id$' ),
		'add_form_url'  => admin_url( 'admin.php?page=rafflepress_' . $rp_version . '_builder&id=0#/template' ),
		'placeholder'   => sprintf( '<img src="%s" width="80px" alt="RafflePress Logo"/>', esc_url( SEEDPROD_PLUGIN_URL . 'public/img/plugin-rp.png' ) ),
	);

	// Check if WooCommerce is active
	if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
		$seedprod_data['wc_active'] = true;
	} else {
		$seedprod_data['wc_active'] = false;
	}

	// Get translations
	$seedprod_data['translations_pro'] = seedprod_lite_get_jed_locale_data( 'coming-soon' );

	echo wp_json_encode( $seedprod_data );
	?>
	;

	jQuery('link[href*="forms.css"]').remove();
	jQuery('link[href*="common.css"]').remove();

</script>

