<?php
/************* COMMENT LAYOUT *********************/

// Comment Form
add_filter( 'comment_form_default_fields', 'ranbron_comment_form_fields' );
function ranbron_comment_form_fields( $fields ) {
	$commenter = wp_get_current_commenter();
	$req = get_option( 'require_name_email' );
	$consent  = empty( $commenter['comment_author_email'] ) ? '' : ' checked="checked"';
	$aria_req = ( $req ? " aria-required='true'" : '' );
	$html5 = current_theme_supports( 'html5', 'comment-form' ) ? 1 : 0;
	$fields = array(
	'author' => '<div class="form-group comment-form-author">' . '<label for="author">' . esc_html__( 'Name', 'ranbron' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
	'<input class="form-control" id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' /></div>',
	'email' => '<div class="form-group comment-form-email"><label for="email">' . esc_html__( 'Email', 'ranbron' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
	'<input class="form-control" id="email" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' /></div>',
	'url' => '<div class="form-group comment-form-url"><label for="url">' . esc_html__( 'Website', 'ranbron' ) . '</label> ' .
	'<input class="form-control" id="url" name="url" ' . ( $html5 ? 'type="url"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" /></div>',
	'cookies' => '<div class="comment-form-cookies-consent"><input id="wp-comment-cookies-consent" name="wp-comment-cookies-consent" type="checkbox" value="yes"' . $consent . ' />' .
					 '<label for="wp-comment-cookies-consent">' . esc_html__( 'Save my name, email, and website in this browser for the next time I comment.', 'ranbron' ) . '</label></div>',
	);
	return $fields;
}

add_filter( 'comment_form_defaults', 'ranbron_comment_form' );
function ranbron_comment_form( $args ) {
	$args['comment_field'] = '<div class="form-group comment-form-comment">
	<label for="comment">' . _x( 'Comment', 'noun', 'ranbron' ) . ( ' <span class="required">*</span>' ) . '</label>
	<textarea class="form-control" id="comment" name="comment" cols="45" rows="8" aria-required="true"></textarea>
	</div>';
	$args['class_submit'] = 'btn btn-secondary'; // since WP 4.1
	return $args;
}


function ranbron_fw_cust_cmnt($comment, $args, $depth) {
    ?>
    <li <?php comment_class( empty( $args['has_children'] ) ? 'single-comment' : 'parent single-comment' ) ?> id="comment-<?php comment_ID() ?>">

		    <div class="comment-author vcard img-box">
		        <?php if ( $args['avatar_size'] != 0 ) echo get_avatar( $comment, $args['avatar_size'] ); ?>
		    </div>
            <!-- .comment-author -->
	<div class="text-box">
		<h4><?php comment_author_link(); ?></h4>
		<?php comment_text(); ?>
		<div class="meta-info">
			<span>
			    <a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ); ?>">
		        <?php
		        /* translators: 1: date, 2: time */
		        printf( esc_html__('%1$s at %2$s', 'ranbron'), get_comment_date(),  get_comment_time() ); ?></a><?php edit_comment_link( esc_html__( '(Edit)', 'ranbron' ), '  ', '' );
		        ?>
			</span>
			<span class="sep">|</span>
	            <?php $tt_reply_text = ''; $tt_reply_text = esc_html__( 'Reply', 'ranbron' ); ?>
                <!-- .comment-metadata -->
					<?php comment_reply_link( array_merge( $args, array( 'reply_text' => $tt_reply_text,  'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
		</div><!-- /.meta-info -->
	</div><!-- /.text-box -->
<?php
}
?>